//Program 7. Simple image watermarking algorithms using LSB substitution
//Note 1: The imread function in SIVP toolbox read the binary image as gray 
//scale image. During bitset it will create problems.
//The grayscale image can be converted into binary image using the function
//gray2bin()
//Note 2: The functions bit_set and bit_get are written inorder to save the
// scilab workspace memory during execution
//Software version
//OS Windows7
//Scilab5.4.1
//Image Processing Design Toolbox 8.3.1-1
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2
clc
clear
close
//Function to find number of elements in an image
function [N] = numel(X)
    //X-input image
    //N- number of elements in image X
    [m,n]= size(X);
    N = m*n;
endfunction
//Function to calculate peak signal to noise ratio
function [psnr,mse,maxerr] = psnr_mse_maxerr(X,Xapp)
//PSNR_MSE_MAXERR Peak signal to noise ratio 
//X - original Image
//Xapp - reconstructed image
//psnr - peak signal to noise ratio
//mse - mean square error
//maxerr -  maximum error
X    = double(X);
Xapp = double(Xapp);
absD = abs(X-Xapp);
A    = absD.^2;
mse  = sum(A(:))/numel(X);
psnr = 10*log10(255*255/mse);
maxerr = round(max(absD(:)));
endfunction
///////////////////////////////////////////////////////////////////////////////
function [A]= gray2bin(B)
    [m,n] = size(B)
    for i = 1:m
        for j = 1:n
            if(B(i,j)>200)
                A(i,j)= 1;
            else
                A(i,j)=0;
            end
        
        end
    
    end
endfunction
///////////////////////////////////////////////////////////////////////////////
function [c]= bit_set(c,b)
    [m,n] = size(c);
    for i=1:m
      for j=1:n
        c(i,j)=bitset(c(i,j),1,b(i,j));
      end
    end
endfunction
///////////////////////////////////////////////////////////////////////////////
function [d] = bit_get(c)
    [m,n] = size(c);
    for i=1:m
        for j=1:n
            d(i,j)=bitget(c(i,j),1);
        end
    end
endfunction
////////////////////////////////////////////////////////////////////////////////
a = imread('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\cameraman.jpeg');  // original image
b = imread('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\wat.jpg');        // watermark image
b = gray2bin(b);
[m n] = size(a);
a = double(a);
c = a;
c = bit_set(c,b);
d = bit_get(c);

figure
ShowImage(a,'Original image');
title('Original image');
figure
ShowImage(b,'watermark image');
title('watermark image');
figure
ShowImage(uint8(c),'watermarked image');
title('watermarked image');
figure
ShowImage(d,'extracted watermark');
title('extracted watermark');
psnr = psnr_mse_maxerr(a,c);
correlation = corr2(b,d);
disp(correlation,'correlation between watermark image and extracted watermark=')
